﻿IF EXISTS (SELECT 1 FROM sys.triggers WHERE object_id = OBJECT_ID(N'VX_tr_OnUpdateRespondent'))
    DROP TRIGGER VX_tr_OnUpdateRespondent
GO

CREATE TRIGGER VX_tr_OnUpdateRespondent
    ON [Respondent]
    AFTER UPDATE
AS 
BEGIN
	SET NOCOUNT ON;
 
	IF UPDATE(ResCompleted) OR UPDATE(ResCallCount) OR UPDATE(ResDisposition) OR UPDATE(ResEmail)
	BEGIN
		UPDATE s
		SET
			s.CompletedOn = CASE WHEN i.ResCompleted <> d.ResCompleted THEN GETUTCDATE() ELSE s.CompletedOn END,
			s.Disposition = CASE WHEN i.ResDisposition <> d.ResDisposition THEN i.ResDisposition ELSE s.Disposition END,
			s.Email = CASE WHEN i.ResEmail <> d.ResEmail THEN i.ResEmail ELSE s.Email END
		FROM RespondentActivitySummary s
		INNER JOIN inserted i ON s.RespondentId = i.ResRespondent
		INNER JOIN deleted d ON i.ResRespondent = d.ResRespondent
			AND (i.ResDisposition <> d.ResDisposition
				OR i.ResEmail <> d.ResEmail
				OR i.ResCompleted <> d.ResCompleted);

		IF EXISTS (
			SELECT 1
			FROM inserted i
			INNER JOIN deleted d ON i.ResRespondent = d.ResRespondent
				AND (i.ResCompleted <> d.ResCompleted
					OR i.ResCallCount <> d.ResCallCount))
		BEGIN
			DECLARE @iProjectId int
			SET @iProjectId = [dbo].GetProjectId(OBJECT_SCHEMA_NAME(@@PROCID))
   
			UPDATE dbo.ProjectStatistics
			SET NeedsUpdate = 1
			WHERE ProjectId=@iProjectId AND NeedsUpdate=0
		END
	END
END
GO
